<!DOCTYPE html>
<html>
<head>
    <title>Sales Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            background-color: #f4f4f4;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .text-end {
            text-align: right;
        }
        h3 {
            color: #4CAF50;
        }
    </style>
</head>
<body>
    <div class="container">
        <div style="text-align: center;">
            <h2 style="margin: 0;">Sales Report</h2>
            <h4 style="margin: 5px 0 20px 0;">Bill Summary</h4>
        </div>

        <?php if($salesByBill->isEmpty()): ?>
            <p>No sales records found.</p>
        <?php else: ?>
            <?php $grandTotal = 0; ?>

            <?php $__currentLoopData = $salesByBill; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billNo => $sales): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $firstPrinted = $sales->first()->FirstTimeBillPrintedOn ?? null;
                    $reprinted = $sales->first()->BillReprintAfterchanges ?? null;
                    $billTotal = 0;
                ?>

                <h5 style="margin-top: 20px; margin-bottom: 5px;">Bill No: <?php echo e($billNo); ?></h5>
                <small>
                    <?php if($firstPrinted): ?>
                        First Printed: <?php echo e(\Carbon\Carbon::parse($firstPrinted)->format('Y-m-d')); ?>

                    <?php endif; ?>
                    <?php if($reprinted): ?>
                        Reprinted: <?php echo e(\Carbon\Carbon::parse($reprinted)->format('Y-m-d')); ?>

                    <?php endif; ?>
                </small>

                <table>
                    <thead>
                        <tr>
                            <th>කේතය</th>
                            <th>පාරිභෝගික කේතය</th>
                            <th>සැපයුම්කරු කේතය</th>
                            <th>භාණ්ඩ නාමය</th>
                            <th>බර</th>
                            <th>කිලෝවකට මිල</th>
                            <th>එකතුව</th>
                            <th>පැකේජ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $billTotal += $sale->total; ?>
                            <tr>
                                <td><?php echo e($sale->code); ?></td>
                                <td><?php echo e($sale->customer_code); ?></td>
                                <td><?php echo e($sale->supplier_code); ?></td>
                                <td><?php echo e($sale->item_name); ?></td>
                                <td><?php echo e($sale->weight); ?></td>
                                <td><?php echo e(number_format($sale->price_per_kg, 2)); ?></td>
                                <td><?php echo e(number_format($sale->total, 2)); ?></td>
                                <td><?php echo e($sale->packs); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="6" class="text-end">Bill Total:</th>
                            <th colspan="2"><?php echo e(number_format($billTotal, 2)); ?></th>
                        </tr>
                    </tfoot>
                </table>

                <?php $grandTotal += $billTotal; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="text-end" style="margin-top: 20px;">
                <h3>Grand Total: <?php echo e(number_format($grandTotal, 2)); ?></h3>
            </div>
        <?php endif; ?>
    </div>
</body>
</html><?php /**PATH /home/wdaylk/public_html/sms/application/resources/views/emails/sales_report.blade.php ENDPATH**/ ?>