

<?php $__env->startSection('content'); ?>

<?php
use Illuminate\Support\Str;
?>

<style>
    body { background-color: #99ff99; }

    /* ===== PRINT SETTINGS ===== */
    @media print {
        @page { size: A4 portrait; margin: 15mm; }

        body * { visibility: hidden; }

        .custom-card, .custom-card * {
            visibility: visible;
        }

        .custom-card {
            position: absolute;
            left: 0;
            top: 0;
            width: 210mm;
            min-height: 297mm;
            margin: auto;
            border: none !important;
            box-shadow: none !important;
            background: white !important;
            color: black !important;
        }

        * {
            color: black !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .print-btn, .btn {
            display: none !important;
        }

        table {
            page-break-inside: auto;
            border-collapse: collapse !important;
        }

        tr { page-break-inside: avoid; page-break-after: auto; }

        thead { display: table-header-group; }
        tfoot { display: table-footer-group; }
    }

    /* ===== SCREEN STYLES ===== */
    .custom-card {
        background-color: #006400;
        color: white;
        padding: 1rem;
    }

    table.table { 
        font-size: 0.9rem; 
        width: 100%; 
        border-collapse: collapse; 
    }

    table.table th, 
    table.table td {
        padding: 0.3rem 0.6rem;
        vertical-align: middle;
        border: 1px solid #004d00;
    }

    table.table thead { background-color: #004d00; }
    table.table tbody tr:nth-child(odd) { background-color: #00550088; }
    table.table tbody tr:nth-child(even) { background-color: transparent; }

    .report-title-bar {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1rem;
    }

    .company-name { font-weight: 700; font-size: 1.5rem; color: white; margin: 0; }

    .right-info {
        color: white;
        font-weight: 600;
        text-align: right;
        font-size: 0.85rem;
    }

    .print-btn {
        background-color: #004d00;
        color: white;
        border: none;
        padding: 0.3rem 0.8rem;
        border-radius: 5px;
        cursor: pointer;
        font-weight: 600;
        font-size: 0.9rem;
        transition: background-color 0.3s ease;
    }

    .print-btn:hover { background-color: #003300; }

    .highlight-red {
        background-color: #ffcccc !important;
        color: #880000;
        font-weight: bold;
    }
</style>

<div class="container mt-2" style="min-height: 100vh; padding: 15px;">
    <div class="card custom-card shadow border-0 rounded-3">

        
        <div class="report-title-bar">
            <h2 class="company-name">Sales Report</h2>
            <h4 class="fw-bold">Processed Sales Summary</h4>

            <?php $settingDate = \App\Models\Setting::value('value'); ?>
            <div class="right-info">
                <span>Report Date: <?php echo e(\Carbon\Carbon::parse($settingDate)->format('Y-m-d')); ?></span>
            </div>

            <button class="print-btn" onclick="window.print()">🖨️ Print</button>
        </div>

        <div class="card-body p-0">

            
            <div class="search-bar-container" style="padding: 0.5rem 0 1rem 0;">
              <input type="text" id="customerSearchInput" class="form-control" placeholder="Search by Customer Code or Bill No (starts with)..." style="background-color: white; border: 1px solid #004d00; color: #333; font-weight: 500; text-transform: uppercase;">
            </div>

            
            <div id="report-content">
                <?php if($salesData->isEmpty()): ?>
                    <div class="alert alert-info m-3">No processed sales records found.</div>
                <?php else: ?>
                    <?php
                        $groupedData = $salesData->groupBy(function($sale) {
                            return $sale->bill_no ?: $sale->customer_code;
                        });
                        $grandTotal = 0;
                        $totalPackCost = 0;
                    ?>

                    <?php $__currentLoopData = $groupedData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupKey => $sales): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $isBill = !empty($sales->first()->bill_no);
                            $billNo = $sales->first()->bill_no;
                            $billTotal = $sales->sum(fn($sale) => $sale->weight * $sale->price_per_kg);
                            $billTotal2 = $sales->sum('total');
                            $packCost = $billTotal2 - $billTotal;
                            $totalPackCost += $packCost;

                            $firstPrinted = $sales->first()->FirstTimeBillPrintedOn ?? null;
                            $reprinted = $sales->first()->BillReprintAfterchanges ?? null;
                            $customerCode = $sales->first()->customer_code ?? '';
                        ?>

                        
                        <div class="report-group-container" 
                             data-customer-code="<?php echo e($customerCode); ?>" 
                             data-bill-no="<?php echo e($billNo ?? ''); ?>">

                            
                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                <h5 class="fw-bold mb-1">
                                    <?php if($isBill): ?>
                                        Bill No: <?php echo e($billNo); ?>

                                        <span class="ms-3 text-white">Customer Code: <?php echo e($customerCode); ?></span>
                                    <?php else: ?>
                                        Customer Code: <?php echo e($customerCode); ?>

                                    <?php endif; ?>
                                </h5>

                                <?php if($isBill): ?>
                                <div class="right-info">
                                    <?php if($firstPrinted): ?>
                                        <span>First Printed: <?php echo e(\Carbon\Carbon::parse($firstPrinted)->format('Y-m-d')); ?></span>
                                    <?php endif; ?>
                                    <?php if($reprinted): ?>
                                        <span>Reprinted: <?php echo e(\Carbon\Carbon::parse($reprinted)->format('Y-m-d')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            </div>

                            
                            <table class="table table-bordered table-striped table-hover table-sm mb-3">
                                <thead class="text-center">
                                    <tr>
                                        <th>කේතය</th>
                                        <th>භාණ්ඩ නාමය</th>
                                        <th>බර</th>
                                        <th>කිලෝවකට මිල</th>
                                        <th>මලු</th>
                                        <th>එකතුව</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $grn = \App\Models\GrnEntry::where('code', trim($sale->code))->first();
                                            $grnPrice = $grn ? (float) $grn->PerKGPrice : null;
                                            $isLower = $grnPrice !== null && $sale->price_per_kg < $grnPrice;
                                        ?>

                                        <tr class="text-center">
                                            <td><?php echo e($sale->code); ?></td>
                                            <td class="text-start"><?php echo e($sale->item_name); ?></td>
                                            <td><?php echo e(number_format($sale->weight, 2)); ?></td>

                                            <td style="<?php echo e($isLower ? 'color:red; font-weight:bold;' : ''); ?>">
                                                <?php echo e(number_format($sale->price_per_kg, 2)); ?>

                                            </td>

                                            <td><?php echo e($sale->packs); ?></td>

                                            <td><?php echo e(number_format($sale->weight * $sale->price_per_kg, 2)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                                <tfoot>
                                    <tr class="fw-bold text-center">
                                        <td colspan="5" class="text-end">Total:</td>
                                        <td><?php echo e(number_format($billTotal, 2)); ?></td>
                                    </tr>

                                    <tr class="fw-bold text-center">
                                        <td colspan="3" class="text-end">Pack Cost:</td>
                                        <td><?php echo e(number_format($packCost, 2)); ?></td>

                                        <td class="text-end">Total with Pack Cost:</td>
                                        <td><?php echo e(number_format($billTotal2, 2)); ?></td>
                                    </tr>
                                </tfoot>

                            </table>

                        </div>

                        <?php $grandTotal += $billTotal2; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                    <div class="text-end fw-bold mt-3 me-3">
                        <h4>Total Pack Cost: <?php echo e(number_format($totalPackCost, 2)); ?></h4>
                        <h3>Grand Total: <?php echo e(number_format($grandTotal, 2)); ?></h3>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="mt-3">
        <a href="<?php echo e(route('sales.report.download', array_merge(request()->all(), ['format' => 'excel']))); ?>" class="btn btn-success me-2">
            Download Excel
        </a>

        <a href="<?php echo e(route('sales.report.download', array_merge(request()->all(), ['format' => 'pdf']))); ?>" class="btn btn-danger">
            Download PDF
        </a>
    </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('customerSearchInput');

    if (searchInput) {
        searchInput.addEventListener('input', function() {
            const searchValue = this.value.toUpperCase().trim();
            const groups = document.querySelectorAll('.report-group-container');

            groups.forEach(group => {
                const cust = (group.dataset.customerCode || '').toUpperCase();
                const bill = (group.dataset.billNo || '').toUpperCase();

                if (cust.startsWith(searchValue) || bill.startsWith(searchValue)) {
                    group.style.display = 'block';
                } else {
                    group.style.display = 'none';
                }
            });
        });
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/wdaylk/public_html/sms/application/resources/views/dashboard/reports/new_sales_report.blade.php ENDPATH**/ ?>