



<?php $__env->startSection('content'); ?>
<style>
    body { background-color: #99ff99; }
    
    .custom-card {
        background-color: #006400;
        color: white;
        padding: 1.5rem;
    }

    .report-title-bar {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        justify-content: space-between;
        gap: 1rem;
        margin-bottom: 1rem;
    }

    .company-name { font-weight: 700; font-size: 1.5rem; color: white; margin: 0; }
    .report-title-bar h4 { margin: 0; font-weight: 700; white-space: nowrap; color: white; }
    .right-info { color: white; font-weight: 600; white-space: nowrap; }
    .print-btn {
        background-color: #004d00;
        color: white;
        border: none;
        padding: 0.4rem 1rem;
        border-radius: 5px;
        cursor: pointer;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }
    .print-btn:hover { background-color: #003300; }

    table.table {
        width: 100%;
        border-collapse: collapse;
        font-size: 0.9rem;
        margin-bottom: 0;
    }
    table.table th, table.table td {
        padding: 0.4rem 0.6rem;
        border: 1px solid #004d00;
        vertical-align: middle;
    }
    table.table thead, table.table tfoot { background-color: #004d00; color: white; }
    table.table tbody tr:nth-child(odd) { background-color: #00800033; }

    /* Print Styles */
    /* Print Styles */
@media print {
    body { background-color: #fff !important; color: #000; }
    .custom-card { background-color: #fff !important; color: #000 !important; box-shadow: none !important; border: none !important; }
    .custom-card table { border: 1px solid #ccc; }
    .custom-card table th, .custom-card table td { border: 1px solid #ccc; color: #000; }
    .custom-card table thead, .custom-card table tfoot { background-color: #eee !important; color: #000 !important; }
    .custom-card table tbody tr:nth-child(odd) { background-color: #f9f9f9 !important; }
    .report-title-bar h2, .report-title-bar h4, .right-info { color: #000 !important; }

    /* Hide buttons and export section */
    .print-btn,
    .btn-success,
    .btn-danger,
    .mt-3.d-flex { display: none !important; }

    body * { visibility: hidden; }
    .custom-card, .custom-card * { visibility: visible; }
    .custom-card { position: absolute; top: 0; left: 0; width: 100%; }
}

</style>

<div class="container mt-4">
    <div class="card shadow border-0 rounded-3 custom-card">

        
        <div class="report-title-bar">
            <?php
    $companyName = \App\Models\Setting::value('CompanyName');
?>

<h2 class="company-name"><?php echo e($companyName ?? 'Default Company'); ?></h2>

            <h4>📄 GRN කේතය අනුව විකුණුම් වාර්තාව</h4>

            <?php $settingDate = \App\Models\Setting::value('value'); ?>
            <span class="right-info"><?php echo e(\Carbon\Carbon::parse($settingDate)->format('Y-m-d')); ?></span>

            <button class="print-btn" onclick="window.print()">🖨️ මුද්‍රණය</button>
        </div>

        
        <div class="mb-3 text-white">
           <span>
    <strong>තෝරාගත් GRN කේතය:</strong> <?php echo e($selectedGrnCode); ?>

    <?php if($selectedGrnEntry): ?>
        <span class="ms-2">
            (<?php echo e($selectedGrnEntry->item_code); ?> - <?php echo e($selectedGrnEntry->item_name); ?>)
        </span>
    <?php endif; ?>
</span>

            <?php if($startDate && $endDate): ?>
                <span class="ms-3"><strong>දිනයන්:</strong> <?php echo e($startDate); ?> සිට <?php echo e($endDate); ?> දක්වා</span>
            <?php elseif($startDate): ?>
                <span class="ms-3"><strong>ආරම්භ දිනය:</strong> <?php echo e($startDate); ?></span>
            <?php elseif($endDate): ?>
                <span class="ms-3"><strong>අවසන් දිනය:</strong> <?php echo e($endDate); ?></span>
            <?php endif; ?>
        </div>

        
        <table class="table table-bordered table-striped table-hover text-center align-middle">
            <thead>
                <tr>
                    <th>🗓️ දිනය</th>
                    <th>බිල් අංකය</th>
                    <th>ගෙණුම්කරු කේතය</th>
                    <th>බර (kg)</th>
                    <th>මිල (1kg)</th>
                    <th>පැක්</th>
                    <th>මුළු මුදල (Rs.)</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $total_packs = 0;
                    $total_weight = 0;
                    $total_amount = 0;
                ?>

                <?php $__empty_1 = true; $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($sale->Date); ?></td>
                        <td><?php echo e($sale->bill_no); ?></td>
                        <td><?php echo e($sale->customer_code); ?></td>
                        <td class="text-end"><?php echo e(number_format($sale->weight, 2)); ?></td>
                        <td class="text-end"><?php echo e(number_format($sale->price_per_kg, 2)); ?></td>
                        <td class="text-end"><?php echo e($sale->packs); ?></td>
                        <td class="text-end fw-bold"><?php echo e(number_format($sale->total, 2)); ?></td>
                    </tr>
                    <?php
                        $total_packs += $sale->packs;
                        $total_weight += $sale->weight;
                        $total_amount += $sale->total;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-3">🚫 වාර්තා නැත</td>
                    </tr>
                <?php endif; ?>
            </tbody>
            <tfoot>
                <tr class="table-dark fw-bold">
                    <td colspan="3" class="text-end">මුළු එකතුව:</td>
                    <td class="text-end"><?php echo e(number_format($total_weight, 2)); ?></td>
                    <td></td>
                    <td class="text-end"><?php echo e($total_packs); ?></td>
                    <td class="text-end"><?php echo e(number_format($total_amount, 2)); ?></td>
                </tr>
            </tfoot>
        </table>

        
        <div class="mt-3 d-flex gap-2 flex-wrap">
            <form action="<?php echo e(route('report.download', ['reportType' => 'grn-sale-code-report', 'format' => 'excel'])); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="submit" class="btn btn-success">⬇️ Download Excel</button>
            </form>

            <form action="<?php echo e(route('report.download', ['reportType' => 'grn-sale-code-report', 'format' => 'pdf'])); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="submit" class="btn btn-danger">⬇️ Download PDF</button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/wdaylk/public_html/sms/application/resources/views/dashboard/reports/grn_sale_code_report.blade.php ENDPATH**/ ?>