

<?php $__env->startSection('content'); ?>
<style>
    body {
        background-color: #99ff99;
    }

    .custom-card {
        background-color: #006400 !important;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        padding: 24px;
    }

    .table thead th {
        background-color: #e6f0ff;
        color: #003366;
        text-align: center;
    }

    .table tbody td {
        vertical-align: middle;
        text-align: center;
    }

    .table-hover tbody tr:hover {
        background-color: #f1f5ff;
    }

    .btn-sm {
        font-size: 0.875rem;
        padding: 6px 12px;
    }

    .btn-primary {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }

    .btn-warning {
        background-color: #ffc107;
        border-color: #ffc107;
        color: #000;
    }

    .btn-danger {
        background-color: #dc3545;
        border-color: #dc3545;
    }

    .btn-add {
        background-color: #198754;
        border-color: #198754;
        color: #fff;
    }

    .btn-add:hover {
        background-color: #157347;
        border-color: #157347;
    }
</style>

<div class="container-fluid mt-5">
    <div class="custom-card">
        <h2 class="mb-4 text-center text-primary">📦 සැපයුම්කරුවන් (Suppliers)</h2>

        <div class="text-end mb-3">
            <a href="<?php echo e(route('suppliers.create')); ?>" class="btn btn-add">+ නව සැපයුම්කරු</a>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success text-center"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover align-middle">
                <thead>
                    <tr>
                        <th>කේතය</th>
                        <th>නම</th>
                        <th>ලිපිනය</th>
                        <th>දුරකථන අංකය</th>
                        <th>ඊමේල්</th>
                        <th>ගිණුම් අංකය</th> 
                        <th>මෙහෙයුම්</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="text-transform: uppercase;"><?php echo e($supplier->code); ?></td>
                            <td><?php echo e($supplier->name); ?></td>
                            <td><?php echo e($supplier->address); ?></td>
                            <td><?php echo e($supplier->phone ?? '-'); ?></td>
                            <td><?php echo e($supplier->email ?? '-'); ?></td>
                            <td><?php echo e($supplier->account_no ?? '-'); ?></td> 
                            <td>
                                <a href="<?php echo e(route('suppliers.edit', $supplier->id)); ?>" class="btn btn-warning btn-sm">යාවත්කාලීන</a>
                                <form action="<?php echo e(route('suppliers.destroy', $supplier->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button type="submit" onclick="return confirm('මෙම සැපයුම්කරු මකන්නද?')" class="btn btn-danger btn-sm">මකන්න</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">සැපයුම්කරුවන් නොමැත</td> 
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/wdaylk/public_html/sms/application/resources/views/dashboard/suppliers/index.blade.php ENDPATH**/ ?>